/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_decompose_endpoint_addr.c,v 1.9 2005/01/26 11:49:18 loic Exp $";

#include <string.h>
#include "mx_auto_config.h"
#include "myriexpress.h"
#include "tcp.h"
#include "internal.h"
#include "mx_byteswap.h"

mx_return_t
mx_decompose_endpoint_addr(mx_endpoint_addr_t endpoint_addr,
			   uint64_t *nic_id,
			   uint32_t *endpoint_id)
{
  struct mx_lib_address *liba;

  liba = (struct mx_lib_address *) &endpoint_addr;
  
  *nic_id = ntohl(liba->ipaddr_n);
  *endpoint_id = (uint32_t)(ntohs(liba->ipport_n) - ENDPOINT_BASE);
  return MX_SUCCESS;
}
